﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Drawing.Drawing2D;
using System.Text;
using System.Windows.Forms;
using Azyobuzi.りすにんぐついったー.Properties;

namespace Azyobuzi.りすにんぐついったー
{
    public partial class AuthForm :StylishForm
    {
        public AuthForm()
        {
            InitializeComponent();
        }

        private void cancelBtn_Click(object sender, EventArgs e)
        {
            this.Close();
        }

        private void okBtn_Click(object sender, EventArgs e)
        {
            if (string.IsNullOrEmpty(textBox1.Text))
            {
                MessageBox.Show(
                    "Twitterの認証画面で表示される暗証番号を入力してください。拒否した場合は[Cancel]をクリックしてください。",
                    "入力エラー", MessageBoxButtons.OK, MessageBoxIcon.Error);

                return;
            }

            var httpCon = Program.twitterConnection;
            if (!httpCon.AuthenticatePinFlow("https://api.twitter.com/oauth/access_token", req, textBox1.Text))
            {
                MessageBox.Show("暗証番号が正しくありません。", "認証エラー", MessageBoxButtons.OK, MessageBoxIcon.Error);
                return;
            }

            var s = SettingsXml.Instance;
            s.accessToken = httpCon.AccessToken;
            s.accessTokenSecret = httpCon.AccessTokenSecret;

            this.DialogResult = DialogResult.OK;
            this.Close();
        }

        string req = "";

        private void AuthForm_Shown(object sender, EventArgs e)
        {
            var httpCon = Program.twitterConnection;
            Uri url=null;
            httpCon.AuthenticatePinFlowRequest("https://api.twitter.com/oauth/request_token", "https://api.twitter.com/oauth/authorize", ref req, ref url);
            System.Diagnostics.Process.Start(url.ToString());
        }
    }
}
